<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://jsahu.me
 * @since      1.0.0
 *
 * @package    Odia_Font_Converter
 * @subpackage Odia_Font_Converter/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Odia_Font_Converter
 * @subpackage Odia_Font_Converter/includes
 * @author     Jnanaranjan Sahu - Gyana <gyana111@gmail.com>
 */
class Odia_Font_Converter_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'odia-font-converter',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
