(function() {
  tinymce.PluginManager.add('ouc_mce_dropdown', function( editor, url ) {
      editor.addButton( 'ouc_mce_dropdown', {
          text: 'Select Font',
          icon: false,
          type: 'menubutton',
          menu: [
              {
               text: 'Akruti',
               onclick: function() {
                  localStorage.setItem("converter_type", 'akruti');
                  convert('akruti');
                }
               },
              {
               text: 'Sreelipi',
               onclick: function() {
                  localStorage.setItem("converter_type", 'sreelipi');
                  convert('sreelipi');
                }
              },
              {
               text: 'Gist',
               onclick: function() {
                  localStorage.setItem("converter_type", 'gist');
                  convert('gist');
                }
              },
              {
               text: 'Apranta',
               onclick: function() {
                  localStorage.setItem("converter_type", 'apranta');
                  convert('apranta');
                }
              },
              {
               text: 'Sambad',
               onclick: function() {
                  // editor.insertContent('[ouc_shortcode 2]');
                  // sessionStorage.setItem("converter_type", 'sambad');
                  localStorage.setItem("converter_type", 'sambad');
                  convert('sambad');
                }
              }
           ]
       });
   });
   tinymce.PluginManager.add('ouc_mce_button', function( editor, url ) {
       editor.addButton('ouc_mce_button', {
         text: 'Convert',
         icon: false,
         onclick: function() {
            if (localStorage.getItem("converter_type")) {
              var type = localStorage.getItem("converter_type");
            } else {
              var type = 'akruti';
            }
            convert(type);
          }
        });
   });
})();

function convert(type) {
  var text = tinymce.activeEditor.getContent();
    jQuery.ajax({
        url: 'https://jsahu.me/api/tools/ouc',
        type:"POST",
        data: { input_text: text, type: type}
      }).done(function(data) {
        if (data.status === 'error') {
          alert(data.message);
          return false;
        } else if (data.status === 'success') {
          if(jQuery('#wp-content-wrap').hasClass('html-active')){ // We are in text mode
              jQuery('#content').val(data.unicode); // Update the textarea's content
          } else { // We are in tinyMCE mode
              var activeEditor = tinyMCE.get('content');
              if(activeEditor!==null){ // Make sure we're not calling setContent on null
                  // activeEditor.setContent(data.unicode); // Update tinyMCE's content
                  activeEditor.setContent(data.unicode.replace(/(?:\r\n|\r|\n)/g, '<br>')); // Update tinyMCE's content
                  // activeEditor.insertContent(data.unicode);
              }
          }
        }
      });
}